#!/bin/bash

# checkmedia.sh
#
# Usage: checkmedia.sh <device file> <media type> <log file>
#
# 00  10/28/2004  P. Provost  Rewritten for support of USB flash memory drives

DEVICEFILE=$1
MEDIA=$2
LOGFILE=$3

echo "-> checkmedia.sh" >> $LOGFILE
echo "Checking if the media is present in the device at $DEVICEFILE for `date`" >> $LOGFILE

# Determine what drive is to be used to check for the presence of the media
case "$MEDIA" in
    1)
        # Check if the media is present in a diskette drive
	echo "Checking a diskette drive for the presence of the media." >> $LOGFILE
	actzTrace "XMDA   F: checkmedia.sh: Checking a diskette drive for the presence of the media."
        
        if dd if=$DEVICEFILE bs=1 skip=32808 count=1 2>&1 | grep -q -i 'No such device or address'; then
            echo "No media is present in the diskette drive." >> $LOGFILE
	    actzTrace "XMDA   F: checkmedia.sh: No media is present in the diskette drive."
            exit 1
        else
            actzTrace "XMDA   F: checkmedia.sh: Media is present in the diskette drive."
	    echo "Media is present in the diskette drive." >> $LOGFILE
	fi
    ;;
    2)
        # Check if the media is present in a CD-ROM/DVD-RAM drive
	echo "Checking a CD-ROM/DVD-RAM drive for the presence of the media." >> $LOGFILE
        actzTrace "XMDA   F: checkmedia.sh: Checking a CD-ROM/DVD-RAM drive for the presence of the media."
	
        if dd if=$DEVICEFILE bs=1 skip=32808 count=1 2>&1 | grep -q -i 'No medium found'; then
	    echo "No media is present in the CD-ROM/DVD-RAM drive." >> $LOGFILE
            actzTrace "XMDA   F: checkmedia.sh: No media is present in the CD-ROM/DVD-RAM drive." 
	    exit 1
	else
	    echo "Media is present in the CD-ROM/DVD-RAM drive." >> $LOGFILE
            actzTrace "XMDA   F: checkmedia.sh: Media is present in the CD-ROM/DVD-RAM drive."
	fi
    ;;
    8)
        # Check if the USB flash memory drive is present
	echo "Checking if a USB flash memory drive is present." >> $LOGFILE
	actzTrace "XMDA   F: checkmedia.sh: Checking if a USB flash memory drive is present."
        
        if dd if=$DEVICEFILE bs=1 skip=32808 count=1 2>&1 | grep -q -i 'No such device or address'; then
            echo "No USB flash memory drive is present." >> $LOGFILE
	    actzTrace "XMDA   F: checkmedia.sh: No USB flash memory drive is present."
            exit 1
        else
            actzTrace "XMDA   F: checkmedia.sh: A USB flash memory drive is present."
	    echo "A USB flash memory drive is present" >> $LOGFILE
	fi
    ;;   
esac

actzTrace "XMDA   T: <- checkmedia.sh"
echo "<- checkmedia.sh" >> $LOGFILE
echo "" >> $LOGFILE

exit 0


